﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class MissionsTimeDifficultyConfiguration : ConfigurationElement
{
    public int BaseRoadTime { get; private set; }
    public float SpeedTimeRatio { get; private set; }

    public MissionsTimeDifficultyConfiguration(string id) : base(id)
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            BaseRoadTime = Convert.ToInt32(configElem.Element("BaseRoadTime").Value);
            SpeedTimeRatio = Convert.ToSingle(configElem.Element("SpeedTimeRatio").Value);
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing mission time difficulty configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
